" vim:set ts=4 sts=4 sw=4 tw=0:
"
" whizzy4vim.vim - Helper script for Whizzy4Vim (WhizzyTeX for Vim).
"
" Version:     0.0.2
" Last Update: 06-Mar-2007.
" Copyright:   Yusuke Nakano <pakuchan@pakunet.jp>
" Author:      Yusuke Nakano <pakuchan@pakunet.jp>
" License:     GNU GPL version 2

scriptencoding UTF-8

if exists('loaded_whizzy4vim') || &cp
    finish
endif
let loaded_whizzy4vim=1

" ----------------------------------------------------------------------------
" Function: TexPreview(operation)
"
" Argument:
"   opration - The string representing the operation of Whizzy4Vim.
"
"              If this is ''cleanup``, Whizzy4Vim removes all temporary
"              files and kill the running WhizzyTeX process.
"
function TexPreview(operation)
	" File extension must be ended by ''.tex``
	if fnamemodify(expand('%'), ':e') != "tex"
		return
	endif

	" Obtain filename and directory editing file
	let filename  = fnamemodify(expand('%'), ':t:r')
	let directory = fnamemodify(expand('%'), ':p:h')

	" Invoke the shell script
	let argument = "whizzy4vim \"" . expand('%') . "\" \"" . directory . "\" "
	if a:operation != "cleanup"
		let argument = argument . line('.') . " " . col('.') . " reslice"
	else
		let argument = argument . "0 0 quit"
	endif
	let result = system(argument)
	if v:shell_error
		echo "An error occured while running Whizzy4Vim."
		echo "Please check the log file of WhizzyTeX (" . directory . "/_whizzy4vim_" . filename . ".whizzytex.log)"
	endif
endfunction
"}}}

" ----------------------------------------------------------------------------
autocmd BufWritePost *.tex call TexPreview("normal")
autocmd VimLeavePre  *.tex call TexPreview("cleanup")

